******************************
* SET OPTIONS; SET LOCATIONS *
******************************
clear all
set trace off
set more off
global external_dir "D:\Dropbox\Michigan\RDC Project\AEJ Data Set\"			/*CHANGE THIS TO THE DIRECTORY THAT HAS THE FILES*/
global internal_dir "\projects\"											/*This is an internal RDC directory*/

capture log close


*********
* Setup *
*********

*Delete any previously cleaned files
forval i = 1(1)51 {
	cap erase "$internal_dir/data/Census 1980/census1980_`i'.dta"
	}
cap erase "$internal_dir/data/Census 1980/census1980est_stock.dta"
cap erase "$internal_dir/data/Census 1980/census1980est_stock_cit.dta"
cap erase "$internal_dir/data/Census 1980/census1980est_stock_noncit.dta"
cap erase "$internal_dir/data/Census 1980/census1980est_stock_bycounty.dta"

*This directory contains all of the original "Personal" Census 1980 files 
	*(by state), which have been converted to .dta format using StatTransfer
local files : dir "/projects/data/Census 1980" files "*.dta"
cd "/projects/data/Census 1980"


********************
* Procure raw data *
********************

*Read in each state's "Personal" Census 1980 file, keeping only immigrants 
	*and necessary variables
local i = 1
foreach file in `files' {
	display "`file'"
	use "`file'", clear
	qui keep pwgt yim pob cit fhg hgr age stfp coup /*Keep only necessary variables*/
	qui destring pob, replace
	qui destring yim, replace
	qui keep if pob>=100 & pob<=998 /*Keep only immigrants*/
	qui drop if cit=="3"		/*Keep only immigrants*/
	rename yim yoe 
	qui save "$internal_dir/data/Census 1980/census1980_`i'.dta"
	local i = `i'+1
	}
display "`i'"
clear 


************************
* Append and Harmonize *
************************

*Append together to create dataset with all immigrant observations from 1980 Census
local end = `i'-1
forval i = 1(1)`end' {
	append using "$internal_dir/data/Census 1980/census1980_`i'.dta"
	erase "$internal_dir/data/Census 1980/census1980_`i'.dta"
	}
	
*Create country variable that accords with 2000 Census and 2005-2014 ACS
gen country=.
replace country = 300 if pob==301 
replace country = 374 if pob==410 
replace country = 360 if pob==411 
replace country = 361 if pob==412 
replace country = 362 if pob==413
replace country = 363 if pob==414 
replace country = 364 if pob==415 
replace country = 365 if pob==416 
replace country = 366 if pob==417 
replace country = 367 if pob==418
replace country = 368 if pob==419 
replace country = 369 if pob==420 
replace country = 370 if pob==421 
replace country = 371 if pob==422 
replace country = 372 if pob==423
replace country = 373 if pob==424 
replace country = 310 if pob==431 
replace country = 311 if pob==432 
replace country = 312 if pob==433 
replace country = 313 if pob==434
replace country = 314 if pob==435 
replace country = 303 if pob==436 
replace country = 315 if pob==437 
replace country = 316 if pob==438 
replace country = 320 if pob==442
replace country = 321 if pob==443 
replace country = 323 if pob==444 
replace country = 324 if pob==445 
replace country = 325 if pob==446 
replace country = 325 if pob==447
replace country = 325 if pob==448 
replace country = 325 if pob==449 
replace country = 325 if pob==450 
replace country = 325 if pob==451 
replace country = 325 if pob==452
replace country = 326 if pob==453 
replace country = 328 if pob==454
replace country = 330 if pob==455
replace country = 333 if pob==456
replace country = 335 if pob==457
replace country = 338 if pob==458
replace country = 339 if pob==459
replace country = 340 if pob==460
replace country = 341 if pob==461
replace country = 342 if pob==462

	*Netherlands Antilles 
	replace country = 336 if pob==463 /* Netherlands Antilles, n.s. */
	replace country = 322 if pob==464 /* Aruba, stays on its own */
	replace country = 336 if pob==465 /* Bonaire --> Netherlands Antilles */
	replace country = 336 if pob==466 /* Curacao --> Netherlands Antilles */
	replace country = 336 if pob==467 /* Dutch St. Maarten --> Netherlands Antilles */
	replace country = 336 if pob==468 /* Saba --> Netherlands Antilles */
	replace country = 336 if pob==469 /* St. Eustatius --> Netherlands Antilles */
	
	*Guadeloupe
	replace country = 331 if pob==472 | pob==475 /*St. Barts --> Guadeloupe*/

replace country = 332 if pob==473
replace country = 334 if pob==474
replace country = 327 if pob==476
replace country = 329 if pob==477
replace country = 402 if pob==121
replace country = 408 if pob==122
replace country = 420 if pob==123
replace country = 421 if pob==124
replace country = 423 if pob==125
replace country = 424 if pob==126
replace country = 425 if pob==127
replace country = 429 if pob==128
replace country = 433 if pob==129
replace country = 434 if pob==130
replace country = 439 if pob==131
replace country = 440 if pob==132
replace country = 450 if pob==133
replace country = 444 if pob==134
replace country = 447 if pob==135
replace country = 454 if pob==136
replace country = 405 if pob==137
replace country = 404 if pob==141
replace country = 406 if pob==142
replace country = 411 if pob==143
replace country = 413 if pob==144
replace country = 416 if pob==145
replace country = 427 if pob==146
replace country = 431 if pob==147
replace country = 432 if pob==148
replace country = 445 if pob==149
replace country = 437 if pob==150
replace country = 441 if pob==151
replace country = 442 if pob==152
replace country = 446 if pob==153
replace country = 448 if pob==154
replace country = 461 if pob==155
replace country = 457 if pob==156
replace country = 453 if pob==157
replace country = 460 if pob==158
replace country = 400 if pob==161
replace country = 414 if pob==162
replace country = 430 if pob==163
replace country = 436 if pob==164
replace country = 451 if pob==165
replace country = 456 if pob==166
replace country = 458 if pob==167
replace country = 401 if pob==171
replace country = 407 if pob==172
replace country = 409 if pob==173
replace country = 410 if pob==174
replace country = 412 if pob==175
replace country = 415 if pob==176
replace country = 419 if pob==177
replace country = 443 if pob==178
replace country = 459 if pob==179
replace country = 403 if pob==181
replace country = 428 if pob==182
replace country = 438 if pob==183
replace country = 449 if pob==184
replace country = 452 if pob==185
replace country = 207 if pob==501
replace country = 209 if pob==502
replace country = 215 if pob==503
replace country = 220 if pob==504 | pob==506 /* "Korea" = South Korea */
replace country = 221 if pob==505
replace country = 225 if pob==507 
replace country = 228 if pob==508
replace country = 240 if pob==509
replace country = 200 if pob==611
replace country = 202 if pob==612
replace country = 203 if pob==613
replace country = 210 if pob==614
replace country = 212 if pob==615
replace country = 227 if pob==616
replace country = 229 if pob==617
replace country = 231 if pob==618
replace country = 238 if pob==619
replace country = 204 if pob==621
replace country = 205 if pob==622
replace country = 250 if pob==623
replace country = 211 if pob==624
replace country = 206 if pob==625
replace country = 223 if pob==626
replace country = 226 if pob==627
replace country = 233 if pob==628
replace country = 236 if pob==629
replace country = 242 if pob==630
replace country = 247 if pob==631
replace country = 201 if pob==641
replace country = 208 if pob==642
replace country = 213 if pob==644
replace country = 214 if pob==645
replace country = 216 if pob==646
replace country = 222 if pob==647
replace country = 224 if pob==648
replace country = 230 if pob==650
replace country = 234 if pob==651
replace country = 235 if pob==652
replace country = 239 if pob==653
replace country = 243 if pob==654
replace country = 245 if pob==655
replace country = 248 if pob==656 | pob==657 /* Yemen */
replace country = 301 if pob==302

*Oceania & Europe
replace country = 60 if pob==60
replace country = 66 if pob==62
replace country = 67 if pob==63
replace country = 71 if pob==64
replace country = 69 if pob==65
replace country = 511 if pob==68
replace country = 58 if pob==69
replace country = 78 if pob==75 | pob==76 | pob==77 | pob==78 | pob==79	/*U.S. Virgin Islands*/
replace country = 72 if pob==81
replace country = 102 if pob==711
replace country = 103 if pob==712
replace country = 109 if pob==713
replace country = 122 if pob==714
replace country = 123 if pob==715
replace country = 125 if pob==716
replace country = 126 if pob==717
replace country = 137 if pob==718
replace country = 100 if pob==721
replace country = 101 if pob==722
replace country = 115 if pob==723
replace country = 116 if pob==724
replace country = 120 if pob==725
replace country = 124 if pob==726
replace country = 129 if pob==727
replace country = 130 if pob==728
replace country = 131 if pob==729
replace country = 133 if pob==730
replace country = 134 if pob==731
replace country = 146 if pob==732
replace country = 155 if pob==742
replace country = 156 if pob==742
replace country = 157 if pob==744
replace country = 104 if pob==745
replace country = 117 if pob==748
replace country = 128 if pob==749
replace country = 132 if pob==750
replace country = 106 if pob==761
replace country = 107 if pob==762
replace country = 108 if pob==763
replace country = 118 if pob==764
replace country = 119 if pob==765
replace country = 127 if pob==766
replace country = 136 if pob==767
replace country = 135 if pob==768
replace country = 138 if pob==769 | pob==773 | pob==774 | pob==775	/*United Kingdom*/
replace country = 145 if pob==772
replace country = 528 if pob==800
replace country = 501 if pob==810
replace country = 515 if pob==820
replace country = 514 if pob==831
replace country = 525 if pob==832
replace country = 517 if pob==833
replace country = 519 if pob==834
replace country = 521 if pob==835
replace country = 505 if pob==841
replace country = 508 if pob==842
replace country = 509 if pob==843
replace country = 523 if pob==844
replace country = 526 if pob==845
replace country = 527 if pob==846
replace country = 512 if pob==850 | pob==67 | pob==70 | pob==71 | pob==72	/*Micronesia*/
replace country = 502 if pob==851
replace country = 510 if pob==853
replace country = 513 if pob==854
replace country = 516 if pob==855
replace country = 520 if pob==856
replace country = 522 if pob==857
replace country = 524 if pob==858
replace country = 158 if pob==901
replace country = 159 if pob==902
replace country = 160 if pob==903
replace country = 161 if pob==904
replace country = 218 if pob==905
replace country = 219 if pob==906
replace country = 162 if pob==907
replace country = 241 if pob==909
replace country = 244 if pob==910
replace country = 164 if pob==911
replace country = 246 if pob==912

**********************	
* Relevant Estimates *
**********************
gen sample1980 = 1 /* This will be used to create counts for each regression cell */
tempfile immi
save `immi', replace

*To produce stock estimates: collapse (sum) pwgt
*To produce counts for supporting documentation: collapse (sum) sample1980
use `immi', clear
collapse (sum) pwgt sample1980, by(country)
rename pwgt stock1980
save "$internal_dir/data/Census 1980/census1980est_stock.dta"

*Citizen Stock
use `immi', clear
keep if cit=="1"
collapse (sum) pwgt sample1980, by(country)
rename pwgt citizen_stock1980
rename sample1980 citizen_stock_sample1980
save "$internal_dir/data/Census 1980/census1980est_stock_cit.dta"

*Non-citizen stock
use `immi', clear
keep if cit=="2"
collapse (sum) pwgt sample1980, by(country)
rename pwgt noncitizen_stock1980
rename sample1980 noncitizen_stock_sample1980
save "$internal_dir/data/Census 1980/census1980est_stock_noncit.dta"

*Stock by county: for concentration index variable
use `immi', clear
gen county = stfp + coup
destring county, replace
collapse (sum) pwgt sample, by(country county)
rename pwgt stock_by_county
rename sample sample_by_county
save "$internal_dir/data/Census 1980/census1980est_stock_bycounty.dta"


